extends Control
class_name Coins


onready var _coins_count : Label = get_node("coins_panel/panel_fg/count")
onready var _coins_icon : TextureRect = get_node("coins_panel/panel_fg/collectable_icon")
onready var _tween : Tween = get_node("Tween")
onready var _animation : AnimationPlayer = get_node("AnimationPlayer")

func init(coins_count : int , coins_icon : Texture) -> void:
	_coins_count.text = str(coins_count)
	_coins_icon.texture = coins_icon
	show()
	UserData.connect("data_changed",self,"_on_data_changed")



func _on_data_changed() -> void:
	_counter_animation()


func _counter_animation() -> void :
	var coins_to : int = B4DFramework.get_coins_count()
	_tween.interpolate_method(self,"_set_coins_count",int(_coins_count.text),
	coins_to,3,Tween.TRANS_CIRC,Tween.EASE_OUT)
	
	_tween.start()


func _set_coins_count(value : int) -> void:
	_coins_count.text = str(value)


func show() -> void :
	_animation.play("coins_appear")


func hide() -> void:
	_animation.play_backwards("coins_appear")
